/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ForceOfNatureEffect
extends OneShotEffect {
    ForceOfNatureEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 8 damage to you unless you pay {G}{G}{G}{G}";
    }

    private ForceOfNatureEffect(ForceOfNatureEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForceOfNatureEffect copy() {
        return new ForceOfNatureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            ManaCostsImpl cost = new ManaCostsImpl("{G}{G}{G}{G}");
            if (!controller.chooseUse(Outcome.Benefit, "Pay {G}{G}{G}{G}?", source, game) || !cost.pay(source, game, source, controller.getId(), false, null)) {
                controller.damage(8, source.getSourceId(), source, game);
            }
            return true;
        }
        return false;
    }
}

