/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;

class ForcedMarchEffect
extends OneShotEffect {
    ForcedMarchEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all creatures with mana value X or less";
    }

    private ForcedMarchEffect(ForcedMarchEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForcedMarchEffect copy() {
        return new ForcedMarchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
            if (permanent.getManaValue() > (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)) continue;
            permanent.destroy(source, game, false);
        }
        return true;
    }
}

