/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class ForeshadowEffect
extends OneShotEffect {
    ForeshadowEffect() {
        super(Outcome.DrawCard);
        this.staticText = "target opponent mills a card. If a card with the chosen name was milled this way, you draw a card";
    }

    private ForeshadowEffect(ForeshadowEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForeshadowEffect copy() {
        return new ForeshadowEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (controller == null || targetPlayer == null || cardName == null || cardName.isEmpty()) {
            return false;
        }
        for (Card card : targetPlayer.millCards(1, source, game).getCards(game)) {
            if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
            controller.drawCards(1, source, game);
            break;
        }
        return true;
    }
}

