/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class ForgottenCreationEffect
extends OneShotEffect {
    ForgottenCreationEffect() {
        super(Outcome.DrawCard);
        this.staticText = "you may discard all the cards in your hand. If you do, draw that many cards";
    }

    private ForgottenCreationEffect(ForgottenCreationEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForgottenCreationEffect copy() {
        return new ForgottenCreationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int cardsInHand = controller.getHand().size();
            if (cardsInHand > 0) {
                controller.discard(cardsInHand, false, false, source, game);
                controller.drawCards(cardsInHand, source, game);
            }
            return true;
        }
        return false;
    }
}

