/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class ForkInTheRoadEffect
extends OneShotEffect {
    protected static final FilterCard filter = new FilterCard("card to put into your hand");

    public ForkInTheRoadEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "Search your library for up to two basic land cards and reveal them. Put one into your hand and the other into your graveyard. Then shuffle";
    }

    private ForkInTheRoadEffect(ForkInTheRoadEffect effect) {
        super((OneShotEffect)effect);
    }

    public ForkInTheRoadEffect copy() {
        return new ForkInTheRoadEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, 2, (FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND);
        if (controller.searchLibrary(target, source, game)) {
            if (!target.getTargets().isEmpty()) {
                Card card;
                CardsImpl revealed = new CardsImpl();
                for (UUID cardId : target.getTargets()) {
                    Card card2 = game.getCard(cardId);
                    if (card2 == null) continue;
                    revealed.add(card2);
                }
                controller.revealCards(sourceObject.getIdName(), (Cards)revealed, game);
                if (!target.getTargets().isEmpty()) {
                    TargetCard target2 = new TargetCard(Zone.LIBRARY, filter);
                    controller.choose(Outcome.Benefit, (Cards)revealed, target2, source, game);
                    Card card3 = revealed.get(target2.getFirstTarget(), game);
                    if (card3 != null) {
                        controller.moveCards(card3, Zone.HAND, source, game);
                        revealed.remove(card3);
                    }
                    if (!revealed.isEmpty() && (card3 = (Card)revealed.getCards(game).iterator().next()) != null) {
                        controller.moveCards(card3, Zone.GRAVEYARD, source, game);
                    }
                } else if (target.getTargets().size() == 1 && !revealed.isEmpty() && (card = (Card)revealed.getCards(game).iterator().next()) != null) {
                    controller.moveCards(card, Zone.HAND, source, game);
                }
            }
            controller.shuffleLibrary(source, game);
            return true;
        }
        controller.shuffleLibrary(source, game);
        return false;
    }
}

