/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FormOfTheDinosaurEffect
extends OneShotEffect {
    FormOfTheDinosaurEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals 15 damage to target creature an opponent controls and that creature deals damage equal to its power to you";
    }

    private FormOfTheDinosaurEffect(FormOfTheDinosaurEffect effect) {
        super((OneShotEffect)effect);
    }

    public FormOfTheDinosaurEffect copy() {
        return new FormOfTheDinosaurEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null) {
                targetCreature.damage(15, source.getSourceId(), source, game, false, true);
                controller.damage(targetCreature.getPower().getValue(), targetCreature.getId(), source, game);
            }
            return true;
        }
        return false;
    }
}

