/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.LoseGameTargetPlayerEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.SquirrelToken;
import mage.game.permanent.token.Token;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FormOfTheSquirrelCreateTokenEffect
extends OneShotEffect {
    FormOfTheSquirrelCreateTokenEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a 1/1 green Squirrel creature token. You lose the game when that creature leaves the battlefield";
    }

    private FormOfTheSquirrelCreateTokenEffect(FormOfTheSquirrelCreateTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player sourceController = game.getPlayer(source.getControllerId());
        if (sourceController != null) {
            CreateTokenEffect effect = new CreateTokenEffect((Token)new SquirrelToken());
            effect.apply(game, source);
            game.getState().setValue(source.getSourceId() + "_token", (Object)effect.getLastAddedTokenIds());
            for (UUID addedTokenId : effect.getLastAddedTokenIds()) {
                LoseGameTargetPlayerEffect loseGameEffect = new LoseGameTargetPlayerEffect();
                loseGameEffect.setTargetPointer((TargetPointer)new FixedTarget(sourceController.getId(), game));
                LeavesBattlefieldTriggeredAbility triggerAbility = new LeavesBattlefieldTriggeredAbility((Effect)loseGameEffect, false);
                GainAbilityTargetEffect continuousEffect = new GainAbilityTargetEffect((Ability)triggerAbility, Duration.WhileOnBattlefield);
                continuousEffect.setTargetPointer((TargetPointer)new FixedTarget(addedTokenId, game));
                game.addEffect((ContinuousEffect)continuousEffect, source);
            }
            return true;
        }
        return false;
    }

    public FormOfTheSquirrelCreateTokenEffect copy() {
        return new FormOfTheSquirrelCreateTokenEffect(this);
    }
}

