/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.BatchTriggeredAbility;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.BecomesMonarchSourceEffect;
import mage.abilities.hint.Hint;
import mage.abilities.hint.common.MonarchHint;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.BatchEvent;
import mage.game.events.DamagedBatchForPlayersEvent;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class ForthEorlingasTriggeredAbility
extends DelayedTriggeredAbility
implements BatchTriggeredAbility<DamagedPlayerEvent> {
    public ForthEorlingasTriggeredAbility() {
        super((Effect)new BecomesMonarchSourceEffect(), Duration.EndOfTurn, false);
        this.setTriggerPhrase("Whenever one or more creatures you control deal combat damage to one or more players this turn, ");
        this.addHint((Hint)MonarchHint.instance);
    }

    private ForthEorlingasTriggeredAbility(ForthEorlingasTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_BATCH_FOR_PLAYERS;
    }

    public boolean checkEvent(DamagedPlayerEvent event, Game game) {
        if (!event.isCombatDamage()) {
            return false;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getSourceId());
        return permanent != null && permanent.isCreature(game) && permanent.isControlledBy(this.getControllerId());
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        return !this.getFilteredEvents((BatchEvent)((DamagedBatchForPlayersEvent)event), game).isEmpty();
    }

    public ForthEorlingasTriggeredAbility copy() {
        return new ForthEorlingasTriggeredAbility(this);
    }
}

