/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.AttackingCreatureCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class FoulTongueShriekEffect
extends OneShotEffect {
    FoulTongueShriekEffect() {
        super(Outcome.Benefit);
        this.staticText = "Target opponent loses 1 life for each attacking creature you control. You gain that much life";
    }

    private FoulTongueShriekEffect(FoulTongueShriekEffect effect) {
        super((OneShotEffect)effect);
    }

    public FoulTongueShriekEffect copy() {
        return new FoulTongueShriekEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetOpponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && targetOpponent != null) {
            int amount = new AttackingCreatureCount(StaticFilters.FILTER_PERMANENT_CREATURES_CONTROLLED).calculate(game, source, (Effect)this);
            if (amount > 0) {
                targetOpponent.loseLife(amount, game, source, false);
                controller.gainLife(amount, game, source);
            }
            return true;
        }
        return false;
    }
}

