/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.FractalToken;

class FractalHarnessTokenEffect
extends OneShotEffect {
    FractalHarnessTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a 0/0 green and blue Fractal creature token. Put X +1/+1 counters on it and attach {this} to it";
    }

    private FractalHarnessTokenEffect(FractalHarnessTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public FractalHarnessTokenEffect copy() {
        return new FractalHarnessTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FractalToken token = new FractalToken();
        token.putOntoBattlefield(1, game, source, source.getControllerId());
        int xValue = GetXValue.instance.calculate(game, source, (Effect)this);
        boolean flag = true;
        for (UUID tokenId : token.getLastAddedTokenIds()) {
            Permanent permanent = game.getPermanent(tokenId);
            if (permanent == null) continue;
            if (flag && permanent.addAttachment(source.getSourceId(), source, game)) {
                flag = false;
            }
            permanent.addCounters(CounterType.P1P1.createInstance(xValue), source.getControllerId(), source, game);
        }
        return true;
    }
}

