/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FracturedLoyaltyEffect
extends OneShotEffect {
    FracturedLoyaltyEffect() {
        super(Outcome.GainControl);
        this.staticText = "that spell or ability's controller gains control of that creature";
    }

    private FracturedLoyaltyEffect(FracturedLoyaltyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null || enchantment.getAttachedTo() == null) {
            return false;
        }
        Permanent enchantedCreature = game.getPermanent(enchantment.getAttachedTo());
        if (enchantedCreature == null) {
            return false;
        }
        Player controller = game.getPlayer(enchantedCreature.getControllerId());
        if (controller != null && !enchantedCreature.isControlledBy(this.getTargetPointer().getFirst(game, source))) {
            GainControlTargetEffect effect = new GainControlTargetEffect(Duration.EndOfGame, this.getTargetPointer().getFirst(game, source));
            effect.setTargetPointer((TargetPointer)new FixedTarget(enchantment.getAttachedTo(), game));
            game.addEffect((ContinuousEffect)effect, source);
            return true;
        }
        return false;
    }

    public FracturedLoyaltyEffect copy() {
        return new FracturedLoyaltyEffect(this);
    }
}

