/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FracturingGustDestroyEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterPermanent();

    public FracturingGustDestroyEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy all artifacts and enchantments. You gain 2 life for each permanent destroyed this way";
    }

    private FracturingGustDestroyEffect(FracturingGustDestroyEffect effect) {
        super((OneShotEffect)effect);
    }

    public FracturingGustDestroyEffect copy() {
        return new FracturingGustDestroyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int destroyedPermanents = 0;
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                if (!permanent.destroy(source, game, false)) continue;
                ++destroyedPermanents;
            }
            game.processAction();
            if (destroyedPermanents > 0) {
                controller.gainLife(2 * destroyedPermanents, game, source);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add(Predicates.or((Predicate)CardType.ARTIFACT.getPredicate(), (Predicate)CardType.ENCHANTMENT.getPredicate()));
    }
}

