/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.common.CardsPutIntoGraveyardWatcher;

class FrayingSanityEffect
extends OneShotEffect {
    FrayingSanityEffect() {
        super(Outcome.Detriment);
        this.staticText = "";
    }

    private FrayingSanityEffect(FrayingSanityEffect effect) {
        super((OneShotEffect)effect);
    }

    public FrayingSanityEffect copy() {
        return new FrayingSanityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent enchantment = source.getSourcePermanentOrLKI(game);
        if (enchantment == null) {
            return false;
        }
        Player enchantedPlayer = game.getPlayer(enchantment.getAttachedTo());
        if (enchantedPlayer != null) {
            CardsPutIntoGraveyardWatcher watcher = (CardsPutIntoGraveyardWatcher)game.getState().getWatcher(CardsPutIntoGraveyardWatcher.class);
            int xAmount = watcher == null ? 0 : watcher.getAmountCardsPutToGraveyard(enchantedPlayer.getId());
            enchantedPlayer.millCards(xAmount, source, game);
            return true;
        }
        return false;
    }
}

