/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FreneticEfreetEffect
extends OneShotEffect {
    FreneticEfreetEffect() {
        super(Outcome.Neutral);
        this.staticText = "Flip a coin. If you win the flip, {this} phases out. If you lose the flip, sacrifice {this}";
    }

    private FreneticEfreetEffect(FreneticEfreetEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        boolean flip = controller.flipCoin(source, game, true);
        if (permanent == null) {
            return false;
        }
        if (flip) {
            return permanent.phaseOut(game);
        }
        permanent.sacrifice(source, game);
        return true;
    }

    public FreneticEfreetEffect copy() {
        return new FreneticEfreetEffect(this);
    }
}

