/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class FreyalisesWindsReplacementEffect
extends ReplacementEffectImpl {
    FreyalisesWindsReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a permanent with a wind counter on it would untap during its controller's untap step, remove all wind counters from it instead";
    }

    private FreyalisesWindsReplacementEffect(FreyalisesWindsReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public FreyalisesWindsReplacementEffect copy() {
        return new FreyalisesWindsReplacementEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanentUntapping = game.getPermanent(event.getTargetId());
        if (permanentUntapping != null) {
            permanentUntapping.removeAllCounters(CounterType.WIND.getName(), source, game);
            return true;
        }
        return false;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP && game.getPhase().getStep().getType() == PhaseStep.UNTAP;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent permanentUntapping = game.getPermanent(event.getTargetId());
        return permanentUntapping != null && event.getPlayerId().equals(permanentUntapping.getControllerId()) && permanentUntapping.getCounters(game).getCount(CounterType.WIND) > 0;
    }
}

