/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.f.FruitcakeElementalControlSourceEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class FruitcakeElementalEffect
extends OneShotEffect {
    FruitcakeElementalEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player gains control of {this}.";
    }

    private FruitcakeElementalEffect(FruitcakeElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public FruitcakeElementalEffect copy() {
        return new FruitcakeElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (player != null && permanent != null) {
            FruitcakeElementalControlSourceEffect effect = new FruitcakeElementalControlSourceEffect();
            game.addEffect((ContinuousEffect)effect, source);
            game.informPlayers(permanent.getName() + " is now controlled by " + player.getLogName());
            return true;
        }
        return false;
    }
}

