/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class FulfillContractEffect
extends OneShotEffect {
    FulfillContractEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy target creature with a bounty counter on it. If that creature is destroyed this way, you may put a +1/+1 counter on target Rogue or Hunter you control";
    }

    private FulfillContractEffect(FulfillContractEffect effect) {
        super((OneShotEffect)effect);
    }

    public FulfillContractEffect copy() {
        return new FulfillContractEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanentToDestroy = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        Permanent permanentToPutCounter = game.getPermanent(((Target)source.getTargets().get(1)).getFirstTarget());
        if (controller != null) {
            if (permanentToDestroy != null && permanentToDestroy.destroy(source, game, false) && permanentToPutCounter != null) {
                permanentToPutCounter.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game);
            }
            return true;
        }
        return false;
    }
}

