/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToHandTargetEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class FumbleEffect
extends OneShotEffect {
    FumbleEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature to its owner's hand. Gain control of all Auras and Equipment that were attached to it, then attach them to another creature";
    }

    private FumbleEffect(FumbleEffect effect) {
        super((OneShotEffect)effect);
    }

    public FumbleEffect copy() {
        return new FumbleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getTargets().getFirstTarget());
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || permanent == null) {
            return false;
        }
        ArrayList<Permanent> attachments = new ArrayList<Permanent>();
        for (UUID permId : permanent.getAttachments()) {
            Permanent attachment = game.getPermanent(permId);
            if (attachment == null || !attachment.hasSubtype(SubType.AURA, game) && !attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
            attachments.add(attachment);
        }
        new ReturnToHandTargetEffect().apply(game, source);
        if (!attachments.isEmpty()) {
            TargetCreaturePermanent target = new TargetCreaturePermanent();
            target.withNotTarget(true);
            Permanent newCreature = null;
            if (player.choose(Outcome.BoostCreature, (Target)target, source, game)) {
                newCreature = game.getPermanent(target.getFirstTarget());
            }
            for (Permanent attachment : attachments) {
                if (!attachment.hasSubtype(SubType.AURA, game) && !attachment.hasSubtype(SubType.EQUIPMENT, game)) continue;
                GainControlTargetEffect effect = new GainControlTargetEffect(Duration.Custom, true, player.getId());
                effect.setTargetPointer((TargetPointer)new FixedTarget(attachment, game));
                game.addEffect((ContinuousEffect)effect, source);
                if (newCreature == null) continue;
                attachment.attachTo(newCreature.getId(), source, game);
            }
        }
        return true;
    }
}

