/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.SpiritWhiteToken;
import mage.players.Player;

class FuneralPyreEffect
extends OneShotEffect {
    FuneralPyreEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile target card from a graveyard. Its owner creates a 1/1 white Spirit creature token with flying";
    }

    private FuneralPyreEffect(FuneralPyreEffect effect) {
        super((OneShotEffect)effect);
    }

    public FuneralPyreEffect copy() {
        return new FuneralPyreEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card exiledCard = game.getCard(source.getFirstTarget());
        if (player == null || exiledCard == null) {
            return false;
        }
        Player owner = game.getPlayer(exiledCard.getOwnerId());
        player.moveCards(exiledCard, Zone.EXILED, source, game);
        if (owner != null) {
            new SpiritWhiteToken().putOntoBattlefield(1, game, source, owner.getId());
        }
        return true;
    }
}

