/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.Objects;
import java.util.Optional;
import mage.MageInt;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.IncubateEffect;
import mage.constants.Outcome;
import mage.game.Game;

class FurnaceGremlinEffect
extends OneShotEffect {
    FurnaceGremlinEffect() {
        super(Outcome.Benefit);
        this.staticText = "incubate X, where X is its power";
    }

    private FurnaceGremlinEffect(FurnaceGremlinEffect effect) {
        super((OneShotEffect)effect);
    }

    public FurnaceGremlinEffect copy() {
        return new FurnaceGremlinEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int power = Optional.ofNullable(source.getSourcePermanentOrLKI(game)).filter(Objects::nonNull).map(MageObject::getPower).map(MageInt::getValue).orElse(0);
        return IncubateEffect.doIncubate((int)power, (Game)game, (Ability)source);
    }
}

