/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterLandPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;

class FurnacePunisherEffect
extends OneShotEffect {
    private static final FilterLandPermanent filter = new FilterLandPermanent();

    FurnacePunisherEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 2 damage to that player unless they control two or more basic lands";
    }

    private FurnacePunisherEffect(FurnacePunisherEffect effect) {
        super((OneShotEffect)effect);
    }

    public FurnacePunisherEffect copy() {
        return new FurnacePunisherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            if (!game.getBattlefield().containsControlled((FilterPermanent)filter, player.getId(), source, game, 2)) {
                player.damage(2, source, game);
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SuperType.BASIC.getPredicate());
    }
}

