/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.f;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.Mode;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DestroyTargetEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.SuspendAbility;
import mage.abilities.keyword.TrampleAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.f.FuryCharmRemoveCounterEffect;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AbilityPredicate;
import mage.target.Target;
import mage.target.common.TargetArtifactPermanent;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetPermanentOrSuspendedCard;

public final class FuryCharm
extends CardImpl {
    private static final FilterCard filter = new FilterCard("suspended card");

    public FuryCharm(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{1}{R}");
        this.getSpellAbility().getModes().setMinModes(1);
        this.getSpellAbility().getModes().setMaxModes(1);
        this.getSpellAbility().addEffect((Effect)new DestroyTargetEffect());
        this.getSpellAbility().addTarget((Target)new TargetArtifactPermanent());
        BoostTargetEffect effect = new BoostTargetEffect(1, 1, Duration.EndOfTurn);
        effect.setText("target creature gets +1/+1");
        Mode mode = new Mode((Effect)effect);
        effect = new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn);
        effect.setText("and gains trample until end of turn");
        mode.addEffect((Effect)effect);
        mode.addTarget((Target)new TargetCreaturePermanent());
        this.getSpellAbility().getModes().addMode(mode);
        mode = new Mode((Effect)new FuryCharmRemoveCounterEffect());
        mode.addTarget((Target)new TargetPermanentOrSuspendedCard());
        this.getSpellAbility().getModes().addMode(mode);
    }

    private FuryCharm(FuryCharm card) {
        super((CardImpl)card);
    }

    public FuryCharm copy() {
        return new FuryCharm(this);
    }

    static {
        filter.add((Predicate)CounterType.TIME.getPredicate());
        filter.add((Predicate)new AbilityPredicate(SuspendAbility.class));
    }
}

