/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;

class EachOpponentGainsLifeEffect
extends OneShotEffect {
    EachOpponentGainsLifeEffect() {
        super(Outcome.Neutral);
        this.staticText = "each opponent gains that much life";
    }

    private EachOpponentGainsLifeEffect(EachOpponentGainsLifeEffect effect) {
        super((OneShotEffect)effect);
    }

    public EachOpponentGainsLifeEffect copy() {
        return new EachOpponentGainsLifeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        game.getOpponents(source.getControllerId()).stream().map(opponentId -> game.getPlayer(opponentId)).filter(opponent -> opponent != null).forEachOrdered(opponent -> {
            int amount = (Integer)this.getValue("damage");
            if (amount > 0) {
                opponent.gainLife(amount, game, source);
            }
        });
        return true;
    }
}

