/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class GaddockTeegReplacementEffectX
extends ContinuousRuleModifyingEffectImpl {
    public GaddockTeegReplacementEffectX() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "Noncreature spells with {X} in their mana costs can't be cast";
    }

    private GaddockTeegReplacementEffectX(GaddockTeegReplacementEffectX effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public GaddockTeegReplacementEffectX copy() {
        return new GaddockTeegReplacementEffectX(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(event.getSourceId());
        return card != null && !card.isCreature(game) && card.getManaCost().getText().contains("X");
    }
}

