/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.PermanentToken;
import mage.watchers.Watcher;

class GadrakTheCrownScourgeWatcher
extends Watcher {
    private int diedThisTurn = 0;

    GadrakTheCrownScourgeWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.isDiesEvent() && zEvent.getTarget() != null && zEvent.getTarget().isCreature(game) && !(zEvent.getTarget() instanceof PermanentToken)) {
            ++this.diedThisTurn;
        }
    }

    public void reset() {
        super.reset();
        this.diedThisTurn = 0;
    }

    int getDiedThisTurn() {
        return this.diedThisTurn;
    }
}

