/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.TwoChoiceVote;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GaladrielElvenQueenEffect
extends OneShotEffect {
    GaladrielElvenQueenEffect() {
        super(Outcome.Benefit);
        this.staticText = "starting with you, each player votes for dominion or guidance. If dominion gets more votes, the Ring tempts you, then you put a +1/+1 counter on your Ring-bearer. If guidance gets more votes or the vote is tied, draw a card.";
    }

    private GaladrielElvenQueenEffect(GaladrielElvenQueenEffect effect) {
        super((OneShotEffect)effect);
    }

    public GaladrielElvenQueenEffect copy() {
        return new GaladrielElvenQueenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TwoChoiceVote vote = new TwoChoiceVote("Dominion", "Guidance", Outcome.Benefit);
        vote.doVotes(source, game);
        int dominionCount = vote.getVoteCount((Object)true);
        int guidanceCount = vote.getVoteCount((Object)false);
        if (dominionCount > guidanceCount) {
            game.temptWithTheRing(controller.getId());
            game.processAction();
            controller = game.getPlayer(source.getControllerId());
            if (controller == null) {
                return false;
            }
            Permanent ringbearer = controller.getRingBearer(game);
            if (ringbearer != null) {
                ringbearer.addCounters(CounterType.P1P1.createInstance(), controller.getId(), source, game);
            }
            return true;
        }
        controller.drawCards(1, source, game);
        return true;
    }
}

