/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class GaladrielElvenQueenWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> elfEnterings = new HashMap<UUID, Set<MageObjectReference>>();

    GaladrielElvenQueenWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD && !game.isSimulation()) {
            Permanent permanent = game.getPermanent(event.getTargetId());
            if (permanent == null || !permanent.hasSubtype(SubType.ELF, game)) {
                return;
            }
            UUID playerId = event.getPlayerId();
            Set setForThatPlayer = this.elfEnterings.getOrDefault(playerId, new HashSet());
            MageObjectReference elfMOR = new MageObjectReference(permanent.getId(), game);
            setForThatPlayer.add(elfMOR);
            this.elfEnterings.put(playerId, setForThatPlayer);
        }
    }

    public void reset() {
        super.reset();
        this.elfEnterings.clear();
    }

    boolean hasPlayerHadAnotherElfEnterThisTurn(Game game, Permanent sourcePermanent, UUID playerId) {
        MageObjectReference sourceMOR = sourcePermanent == null ? null : new MageObjectReference(sourcePermanent.getId(), game);
        Set setForThePlayer = this.elfEnterings.getOrDefault(playerId, new HashSet());
        return setForThePlayer.stream().anyMatch(elfMOR -> !elfMOR.equals((Object)sourceMOR));
    }
}

