/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldAttachToTarget;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class GaleaKindlerOfHopeEffect
extends ContinuousEffectImpl {
    private final MageObjectReference spellRef;
    private final MageObjectReference permRef;
    private final Ability ability = new EntersBattlefieldAttachToTarget().setTriggerPhrase("When this Equipment enters, ");

    GaleaKindlerOfHopeEffect(Spell spell, Game game) {
        super(Duration.Custom, Layer.AbilityAddingRemovingEffects_6, SubLayer.NA, Outcome.Benefit);
        this.spellRef = new MageObjectReference((MageObject)spell, game);
        this.permRef = new MageObjectReference((MageObject)spell.getMainCard(), game, 1);
    }

    private GaleaKindlerOfHopeEffect(GaleaKindlerOfHopeEffect effect) {
        super((ContinuousEffectImpl)effect);
        this.spellRef = effect.spellRef;
        this.permRef = effect.permRef;
    }

    public GaleaKindlerOfHopeEffect copy() {
        return new GaleaKindlerOfHopeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(this.spellRef.getSourceId());
        if (spell != null && spell.getZoneChangeCounter(game) == this.spellRef.getZoneChangeCounter()) {
            game.getState().addOtherAbility(spell.getCard(), this.ability);
            return true;
        }
        Permanent permanent = this.permRef.getPermanent(game);
        if (permanent == null) {
            this.discard();
            return false;
        }
        permanent.addAbility(this.ability, source.getSourceId(), game);
        return true;
    }
}

