/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RemoveVariableCountersTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class GallopingLizrogEffect
extends OneShotEffect {
    GallopingLizrogEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove any number of +1/+1 counters from among creatures you control. If you do, put twice that many +1/+1 counters on {this}";
    }

    private GallopingLizrogEffect(GallopingLizrogEffect effect) {
        super((OneShotEffect)effect);
    }

    public GallopingLizrogEffect copy() {
        return new GallopingLizrogEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        RemoveVariableCountersTargetCost variableCost = new RemoveVariableCountersTargetCost((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, CounterType.P1P1);
        int toPay = variableCost.announceXValue(source, game);
        Cost cost = variableCost.getFixedCostsFromAnnouncedValue(toPay);
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        return new AddCountersSourceEffect(CounterType.P1P1.createInstance(2 * toPay)).apply(game, source);
    }
}

