/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.MayCastTargetCardEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CastManaAdjustment;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GalvanothEffect
extends OneShotEffect {
    GalvanothEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "look at the top card of your library. You may cast it without paying its mana cost if it's an instant or sorcery spell";
    }

    private GalvanothEffect(GalvanothEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Card card = controller.getLibrary().getFromTop(game);
            if (card != null) {
                controller.lookAtCards(source, null, (Cards)new CardsImpl(card), game);
                if (card.isInstantOrSorcery(game)) {
                    new MayCastTargetCardEffect(CastManaAdjustment.WITHOUT_PAYING_MANA_COST).setTargetPointer((TargetPointer)new FixedTarget(card.getId())).apply(game, source);
                }
            }
            return true;
        }
        return false;
    }

    public GalvanothEffect copy() {
        return new GalvanothEffect(this);
    }
}

