/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class GamePreserveEffect
extends OneShotEffect {
    GamePreserveEffect() {
        super(Outcome.Detriment);
        this.staticText = "each player reveals the top card of their library. If all cards revealed this way are creature cards, put those cards onto the battlefield under their owners' control";
    }

    private GamePreserveEffect(GamePreserveEffect effect) {
        super((OneShotEffect)effect);
    }

    public GamePreserveEffect copy() {
        return new GamePreserveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null) continue;
            cards.add(player.getLibrary().getFromTop(game));
        }
        controller.revealCards(source, (Cards)cards, game);
        if (cards.isEmpty() || cards.count(StaticFilters.FILTER_CARD_NON_CREATURE, game) > 0) {
            return false;
        }
        controller.moveCards(cards.getCards(game), Zone.BATTLEFIELD, source, game, false, false, true, null);
        return true;
    }
}

