/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardAllEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;

class GandalfWestwardVoyagerEffect
extends OneShotEffect {
    GandalfWestwardVoyagerEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent reveals the top card of their library. If any of those cards shares a card type with that spell, copy that spell, you may choose new targets for the copy, and each opponent draws a card. Otherwise, you draw a card";
    }

    private GandalfWestwardVoyagerEffect(GandalfWestwardVoyagerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GandalfWestwardVoyagerEffect copy() {
        return new GandalfWestwardVoyagerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source));
        List typesSpell = spell == null ? new ArrayList() : spell.getCardType(game);
        boolean foundCard = false;
        for (UUID playerId : game.getOpponents(source.getControllerId())) {
            Card card;
            Player player = game.getPlayer(playerId);
            if (player == null || (card = player.getLibrary().getFromTop(game)) == null) continue;
            player.revealCards(source, " \u2014 " + player.getName(), (Cards)new CardsImpl(card), game, true);
            HashSet types = new HashSet(card.getCardType(game));
            types.retainAll(typesSpell);
            foundCard |= !types.isEmpty();
        }
        if (foundCard) {
            if (spell != null) {
                spell.createCopyOnStack(game, source, source.getControllerId(), true);
            }
            new DrawCardAllEffect(1, TargetController.OPPONENT).apply(game, source);
        } else {
            new DrawCardSourceControllerEffect(1).apply(game, source);
        }
        return true;
    }
}

