/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GargantuanGorillaSacrificeEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent("a Forest");
    private static final FilterPermanent filterSnow = new FilterPermanent("snow permanent");

    public GargantuanGorillaSacrificeEffect() {
        super(Outcome.Sacrifice);
        this.staticText = "you may sacrifice a Forest. If you sacrifice a snow Forest this way, {this} gains trample until end of turn. If you don't sacrifice a Forest, sacrifice {this} and it deals 7 damage to you.";
    }

    private GargantuanGorillaSacrificeEffect(GargantuanGorillaSacrificeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GargantuanGorillaSacrificeEffect copy() {
        return new GargantuanGorillaSacrificeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (controller != null && sourcePermanent != null) {
            SacrificeTargetCost cost = new SacrificeTargetCost(1, (FilterPermanent)filter);
            if (!(controller.chooseUse(Outcome.Benefit, "Sacrifice a Forest?", source, game) && cost.canPay(source, source, source.getControllerId(), game) && cost.pay(source, game, source, source.getControllerId(), true))) {
                sourcePermanent.sacrifice(source, game);
                controller.damage(7, sourcePermanent.getId(), source, game);
            } else if (cost.isPaid()) {
                for (Permanent permanent : cost.getPermanents()) {
                    if (!filterSnow.match((Object)permanent, game)) continue;
                    game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn), source);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    static {
        filter.add((Predicate)SubType.FOREST.getPredicate());
        filterSnow.add((Predicate)SuperType.SNOW.getPredicate());
    }
}

