/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GarlandKnightOfCorneliaEffect
extends OneShotEffect {
    GarlandKnightOfCorneliaEffect() {
        super(Outcome.Benefit);
        this.staticText = "return this card from your graveyard to the battlefield transformed";
    }

    private GarlandKnightOfCorneliaEffect(GarlandKnightOfCorneliaEffect effect) {
        super((OneShotEffect)effect);
    }

    public GarlandKnightOfCorneliaEffect copy() {
        return new GarlandKnightOfCorneliaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = Optional.ofNullable(source.getSourceObjectIfItStillExists(game)).filter(Card.class::isInstance).map(Card.class::cast).orElse(null);
        if (player == null || card == null) {
            return false;
        }
        game.getState().setValue("EnterTransformed" + card.getId(), (Object)Boolean.TRUE);
        return player.moveCards(card, Zone.BATTLEFIELD, source, game);
    }
}

