/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import mage.ApprovingObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.repository.CardCriteria;
import mage.cards.repository.CardInfo;
import mage.cards.repository.CardRepository;
import mage.choices.Choice;
import mage.choices.ChoiceHintType;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GarthOneEyeEffect
extends OneShotEffect {
    private static final List<String> names = Arrays.asList("Disenchant", "Braingeyser", "Terror", "Shivan Dragon", "Regrowth", "Black Lotus");
    private static final Map<String, Card> cardMap = new HashMap<String, Card>();

    private static final void initMap() {
        if (!cardMap.isEmpty()) {
            return;
        }
        cardMap.putAll(CardRepository.instance.findCards(new CardCriteria().setCodes(new String[]{"LEA"})).stream().filter(cardInfo -> names.contains(cardInfo.getName())).collect(Collectors.toMap(CardInfo::getName, CardInfo::createCard)));
    }

    GarthOneEyeEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a card name that hasn't been chosen from among Disenchant, Braingeyser, Terror, Shivan Dragon, Regrowth, and Black Lotus. Create a copy of the card with the chosen name. You may cast the copy";
    }

    private GarthOneEyeEffect(GarthOneEyeEffect effect) {
        super((OneShotEffect)effect);
    }

    public GarthOneEyeEffect copy() {
        return new GarthOneEyeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String chosen;
        GarthOneEyeEffect.initMap();
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Set<String> alreadyChosen = GarthOneEyeEffect.getAlreadyChosen(game, source);
        LinkedHashSet<String> choices = new LinkedHashSet<String>(names);
        choices.removeAll(alreadyChosen);
        switch (choices.size()) {
            case 0: {
                return false;
            }
            case 1: {
                chosen = choices.stream().findAny().orElse(null);
                break;
            }
            default: {
                ChoiceImpl choice = new ChoiceImpl(true, ChoiceHintType.CARD);
                choice.setChoices(choices);
                player.choose(this.outcome, (Choice)choice, game);
                chosen = choice.getChoice();
            }
        }
        alreadyChosen.add(chosen);
        Card card = cardMap.get(chosen);
        if (card == null || !player.chooseUse(this.outcome, "Cast " + card.getName() + '?', source, game)) {
            return false;
        }
        Card copiedCard = game.copyCard(card, source, source.getControllerId());
        copiedCard.setZone(Zone.OUTSIDE, game);
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), (Object)Boolean.TRUE);
        player.cast(player.chooseAbilityForCast(copiedCard, game, false), game, false, new ApprovingObject(source, game));
        game.getState().setValue("PlayFromNotOwnHandZone" + copiedCard.getId(), null);
        return true;
    }

    private static final Set<String> getAlreadyChosen(Game game, Ability source) {
        String key = GarthOneEyeEffect.getKey(source);
        Object value = game.getState().getValue(key);
        if (value instanceof Set) {
            return (Set)value;
        }
        HashSet<String> alreadyChosen = new HashSet<String>();
        game.getState().setValue(key, alreadyChosen);
        return alreadyChosen;
    }

    static final String getKey(Ability source) {
        return source.getSourceId() + "_" + source.getStackMomentSourceZCC() + "_" + source.getOriginalId() + "_garth";
    }
}

