/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class GateToTheAetherEffect
extends OneShotEffect {
    GateToTheAetherEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "that player reveals the top card of their library. If it's an artifact, creature, enchantment, or land card, the player may put it onto the battlefield";
    }

    private GateToTheAetherEffect(GateToTheAetherEffect effect) {
        super((OneShotEffect)effect);
    }

    public GateToTheAetherEffect copy() {
        return new GateToTheAetherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player activePlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (activePlayer != null) {
            Card card = activePlayer.getLibrary().getFromTop(game);
            if (card != null) {
                activePlayer.revealCards("Gate to the Aether", (Cards)new CardsImpl(card), game);
                if ((card.isArtifact(game) || card.isCreature(game) || card.isEnchantment(game) || card.isLand(game)) && activePlayer.chooseUse(Outcome.PutCardInPlay, "Put " + card.getName() + " onto the battlefield?", source, game)) {
                    activePlayer.moveCards(card, Zone.BATTLEFIELD, source, game);
                }
            }
            return true;
        }
        return false;
    }
}

