/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.TargetPermanent;

class GauntletsOfChaosSecondTarget
extends TargetPermanent {
    public GauntletsOfChaosSecondTarget() {
        this.filter = this.filter.copy();
        this.filter.add((ObjectSourcePlayerPredicate)TargetController.OPPONENT.getControllerPredicate());
        this.withTargetName("permanent an opponent controls that shares one of those types with it");
    }

    private GauntletsOfChaosSecondTarget(GauntletsOfChaosSecondTarget target) {
        super((TargetPermanent)target);
    }

    public boolean canTarget(UUID id, Ability source, Game game) {
        Permanent ownPermanent = game.getPermanent(source.getFirstTarget());
        Permanent possiblePermanent = game.getPermanent(id);
        if (ownPermanent == null || possiblePermanent == null) {
            return false;
        }
        return super.canTarget(id, source, game) && ownPermanent.shareTypes((Card)possiblePermanent, game);
    }

    public Set<UUID> possibleTargets(UUID sourceControllerId, Ability source, Game game) {
        HashSet<UUID> possibleTargets = new HashSet<UUID>();
        Permanent ownPermanent = game.getPermanent(source.getFirstTarget());
        for (Permanent permanent : game.getBattlefield().getActivePermanents(this.filter, sourceControllerId, source, game)) {
            if (ownPermanent == null) {
                possibleTargets.add(permanent.getId());
                continue;
            }
            if (!permanent.shareTypes((Card)ownPermanent, game)) continue;
            possibleTargets.add(permanent.getId());
        }
        possibleTargets.removeIf(id -> ownPermanent != null && ownPermanent.getId().equals(id));
        return this.keepValidPossibleTargets(possibleTargets, sourceControllerId, source, game);
    }

    public boolean chooseTarget(Outcome outcome, UUID playerId, Ability source, Game game) {
        return super.chooseTarget(Outcome.GainControl, playerId, source, game);
    }

    public GauntletsOfChaosSecondTarget copy() {
        return new GauntletsOfChaosSecondTarget(this);
    }
}

