/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class GaviNestWardenWatcher
extends Watcher {
    private final Map<UUID, Integer> playerCyclingActivations = new HashMap<UUID, Integer>();

    GaviNestWardenWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() == GameEvent.EventType.CYCLED_CARD) {
            this.playerCyclingActivations.merge(event.getPlayerId(), 1, Integer::sum);
        }
    }

    int cyclingActivationsThisTurn(UUID playerId) {
        return this.playerCyclingActivations.getOrDefault(playerId, 0);
    }

    public void reset() {
        super.reset();
        this.playerCyclingActivations.clear();
    }
}

