/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.TargetPermanent;

class GemcutterBuccaneerEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent treasureFilter = new FilterControlledPermanent(SubType.TREASURE);
    private static final FilterPermanent pirateFilter = new FilterControlledCreaturePermanent(SubType.PIRATE, "Pirate");

    GemcutterBuccaneerEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Treasures you control are Equipment in addition to their other types and have \"Equipped creature gets +2/+0,\" equip Pirate {1}, and equip {3}.";
    }

    private GemcutterBuccaneerEffect(GemcutterBuccaneerEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public GemcutterBuccaneerEffect copy() {
        return new GemcutterBuccaneerEffect(this);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        for (Permanent permanent : game.getBattlefield().getActivePermanents(treasureFilter, source.getControllerId(), source, game)) {
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.EQUIPMENT});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    permanent.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEquippedEffect(2, 0)), source.getSourceId(), game);
                    permanent.addAbility((Ability)new EquipAbility(Outcome.BoostCreature, (Cost)new GenericManaCost(1), (Target)new TargetPermanent(pirateFilter), false), source.getSourceId(), game);
                    permanent.addAbility((Ability)new EquipAbility(3), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public boolean hasLayer(Layer layer) {
        return layer == Layer.TypeChangingEffects_4 || layer == Layer.AbilityAddingRemovingEffects_6;
    }
}

