/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.combat.CombatGroup;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class GeneralJarkeldSwitchBlockersEffect
extends OneShotEffect {
    GeneralJarkeldSwitchBlockersEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose two target blocked attacking creatures. If each of those creatures could be blocked by all creatures that the other is blocked by, each creature that's blocking exactly one of those attacking creatures stops blocking it and is blocking the other attacking creature";
    }

    private GeneralJarkeldSwitchBlockersEffect(GeneralJarkeldSwitchBlockersEffect effect) {
        super((OneShotEffect)effect);
    }

    public GeneralJarkeldSwitchBlockersEffect copy() {
        return new GeneralJarkeldSwitchBlockersEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        List targets = ((Target)source.getTargets().get(0)).getTargets();
        if (controller != null && targets != null) {
            Permanent attacker1 = game.getPermanent((UUID)targets.get(0));
            Permanent attacker2 = game.getPermanent((UUID)targets.get(1));
            if (attacker1 != null && attacker2 != null) {
                CombatGroup chosenGroup1 = game.getCombat().findGroup(attacker1.getId());
                CombatGroup chosenGroup2 = game.getCombat().findGroup(attacker2.getId());
                if (chosenGroup1 != null && chosenGroup2 != null) {
                    int attackerCount;
                    Permanent blocker;
                    HashSet<Permanent> blockers1 = new HashSet<Permanent>();
                    HashSet<Permanent> blockers2 = new HashSet<Permanent>();
                    HashSet<Permanent> multiBlockers = new HashSet<Permanent>();
                    block0: for (UUID blockerId : chosenGroup1.getBlockers()) {
                        blocker = game.getPermanent(blockerId);
                        if (blocker == null) continue;
                        if (game.getCombat().blockingGroupsContains(blocker.getId())) {
                            for (CombatGroup group : game.getCombat().getBlockingGroups()) {
                                if (!group.getBlockers().contains(blocker.getId())) continue;
                                attackerCount = group.getAttackers().size();
                                if (attackerCount > 1) {
                                    multiBlockers.add(blocker);
                                    continue block0;
                                }
                                if (attackerCount != 1) continue block0;
                                blockers1.add(blocker);
                                continue block0;
                            }
                            continue;
                        }
                        blockers1.add(blocker);
                    }
                    block2: for (UUID blockerId : chosenGroup2.getBlockers()) {
                        blocker = game.getPermanent(blockerId);
                        if (blocker == null) continue;
                        if (game.getCombat().blockingGroupsContains(blocker.getId())) {
                            for (CombatGroup group : game.getCombat().getBlockingGroups()) {
                                if (!group.getBlockers().contains(blocker.getId())) continue;
                                attackerCount = group.getAttackers().size();
                                if (attackerCount > 1) {
                                    multiBlockers.add(blocker);
                                    continue block2;
                                }
                                if (attackerCount != 1) continue block2;
                                blockers2.add(blocker);
                                continue block2;
                            }
                            continue;
                        }
                        blockers2.add(blocker);
                    }
                    this.handleSingleBlockers(blockers1, chosenGroup1, chosenGroup2, controller, game);
                    this.handleSingleBlockers(blockers2, chosenGroup2, chosenGroup1, controller, game);
                    this.handleMultiBlockers(multiBlockers, chosenGroup1, chosenGroup2, controller, game);
                    if (!chosenGroup1.getBlockers().isEmpty()) {
                        chosenGroup1.setBlocked(true, game);
                    }
                    if (!chosenGroup2.getBlockers().isEmpty()) {
                        chosenGroup2.setBlocked(true, game);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void handleSingleBlockers(Set<Permanent> blockers, CombatGroup chosenGroup, CombatGroup otherGroup, Player controller, Game game) {
        for (Permanent blocker : blockers) {
            chosenGroup.remove(blocker.getId());
            blocker.setBlocking(0);
            otherGroup.addBlockerToGroup(blocker.getId(), controller.getId(), game);
        }
    }

    private void handleMultiBlockers(Set<Permanent> blockers, CombatGroup chosenGroup1, CombatGroup chosenGroup2, Player controller, Game game) {
        block0: for (Permanent blocker : blockers) {
            CombatGroup blockGroup = null;
            for (CombatGroup group : game.getCombat().getBlockingGroups()) {
                if (!group.getBlockers().contains(blocker.getId())) continue;
                blockGroup = group;
                break;
            }
            if (blockGroup == null) continue;
            Object chosenGroup = null;
            boolean sameBlocked = false;
            for (CombatGroup group : game.getCombat().getGroups()) {
                if (!group.getBlocked() || !group.getBlockers().contains(blocker.getId()) || group != chosenGroup1 && group != chosenGroup2) continue;
                if (sameBlocked) continue block0;
                sameBlocked = true;
                chosenGroup = group;
            }
            if (!sameBlocked || chosenGroup == null) continue;
            CombatGroup otherGroup = chosenGroup.equals(chosenGroup1) ? chosenGroup2 : chosenGroup1;
            chosenGroup.remove(blocker.getId());
            for (UUID attacker : chosenGroup.getAttackers()) {
                blockGroup.remove(attacker);
            }
            otherGroup.addBlockerToGroup(blocker.getId(), controller.getId(), game);
            for (UUID attacker : otherGroup.getAttackers()) {
                game.getCombat().addBlockingGroup(blocker.getId(), attacker, controller.getId(), game);
            }
        }
    }
}

