/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import mage.MageObject;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class GeneratorServantWatcher
extends Watcher {
    private final List<UUID> creatures = new ArrayList<UUID>();

    public GeneratorServantWatcher() {
        super(WatcherScope.CARD);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.MANA_PAID) {
            return;
        }
        MageObject target = game.getObject(event.getTargetId());
        if (!(target instanceof Spell)) {
            return;
        }
        if (!event.getFlag()) {
            return;
        }
        if (event.getSourceId() == null || !event.getSourceId().equals(this.getSourceId())) {
            return;
        }
        if (target.isCreature(game)) {
            this.creatures.add(((Spell)target).getCard().getId());
        }
    }

    public void reset() {
        super.reset();
        this.creatures.clear();
    }

    public boolean creatureCastWithServantsMana(UUID permanentId) {
        return this.creatures.contains(permanentId);
    }
}

