/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Duration;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class GenestealerLocusTriggeredAbility
extends TriggeredAbilityImpl {
    public GenestealerLocusTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BoostTargetEffect(0, 1, Duration.EndOfTurn), false);
    }

    private GenestealerLocusTriggeredAbility(GenestealerLocusTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        if (game.getOpponents(this.getControllerId()).contains(event.getTargetId())) {
            this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(event.getSourceId(), game));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature attacks one of your opponents, it gets +0/+1 until end of turn.";
    }

    public GenestealerLocusTriggeredAbility copy() {
        return new GenestealerLocusTriggeredAbility(this);
    }
}

