/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class GenestealerPatriarchCloneEffect
extends OneShotEffect {
    GenestealerPatriarchCloneEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "you create a token that's a copy of that creature, except it's a Tyranid in addition to its other types";
    }

    private GenestealerPatriarchCloneEffect(GenestealerPatriarchCloneEffect effect) {
        super((OneShotEffect)effect);
    }

    public GenestealerPatriarchCloneEffect copy() {
        return new GenestealerPatriarchCloneEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent creature = (Permanent)this.getValue("creatureDied");
        if (controller == null || creature == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(source.getControllerId());
        effect.setSavedPermanent(creature);
        effect.withAdditionalSubType(SubType.TYRANID);
        return effect.apply(game, source);
    }
}

