/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.MageInt;
import mage.abilities.Ability;
import mage.abilities.common.DiesAttachedTriggeredAbility;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.ReturnToHandSourceEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureAttachedWithActivatedAbilityOrSpellEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TokenImpl;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class GenjuOfTheFens
extends CardImpl {
    private static final FilterPermanent FILTER = new FilterPermanent(SubType.SWAMP, "Swamp");

    public GenjuOfTheFens(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{B}");
        this.subtype.add((Object)SubType.AURA);
        TargetPermanent auraTarget = new TargetPermanent(FILTER);
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.PutCreatureInPlay));
        this.addAbility((Ability)new EnchantAbility((Target)auraTarget));
        this.addAbility((Ability)new SimpleActivatedAbility((Effect)new BecomesCreatureAttachedWithActivatedAbilityOrSpellEffect((Token)new SpiritToken(), "Until end of turn, enchanted Swamp becomes a 2/2 black Spirit creature with \"{B}: This creature gets +1/+1 until end of turn.\" It's still a land", Duration.EndOfTurn), (Cost)new GenericManaCost(2)));
        this.addAbility((Ability)new DiesAttachedTriggeredAbility((Effect)new ReturnToHandSourceEffect(false, true).setText("you may return {this} from your graveyard to your hand"), "enchanted Swamp", true, false));
    }

    private GenjuOfTheFens(GenjuOfTheFens card) {
        super((CardImpl)card);
    }

    public GenjuOfTheFens copy() {
        return new GenjuOfTheFens(this);
    }

    private static class SpiritToken
    extends TokenImpl {
        SpiritToken() {
            super("Spirit", "2/2 black Spirit creature with \"{B}: This creature gets +1/+1 until end of turn.\"");
            this.cardType.add(CardType.CREATURE);
            this.color.setBlack(true);
            this.subtype.add((Object)SubType.SPIRIT);
            this.power = new MageInt(2);
            this.toughness = new MageInt(2);
            this.addAbility((Ability)new SimpleActivatedAbility((Effect)new BoostSourceEffect(1, 1, Duration.EndOfTurn), (Cost)new ManaCostsImpl("{B}")));
        }

        private SpiritToken(SpiritToken token) {
            super((TokenImpl)token);
        }

        public SpiritToken copy() {
            return new SpiritToken(this);
        }
    }
}

