/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.CommanderCardType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class GeodeGolemEffect
extends OneShotEffect {
    GeodeGolemEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "you may cast your commander from the command zone without paying its mana cost";
    }

    private GeodeGolemEffect(GeodeGolemEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(game.getCommanderCardsFromCommandZone(controller, CommanderCardType.COMMANDER_OR_OATHBREAKER));
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)cards, (FilterCard)StaticFilters.FILTER_CARD);
    }

    public GeodeGolemEffect copy() {
        return new GeodeGolemEffect(this);
    }
}

