/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.watchers.Watcher;

class GeralfTheFleshwrightWatcher
extends Watcher {
    private final Map<UUID, Set<MageObjectReference>> enteredThisTurn = new HashMap<UUID, Set<MageObjectReference>>();

    GeralfTheFleshwrightWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ENTERS_THE_BATTLEFIELD) {
            return;
        }
        Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
        if (permanent == null || !permanent.hasSubtype(SubType.ZOMBIE, game)) {
            return;
        }
        Player controller = game.getPlayer(event.getPlayerId());
        if (controller == null) {
            return;
        }
        this.enteredThisTurn.computeIfAbsent(controller.getId(), k -> new HashSet()).add(new MageObjectReference((MageObject)permanent, game));
    }

    public void reset() {
        super.reset();
        this.enteredThisTurn.clear();
    }

    int getZombiesThatEnteredThisTurn(UUID playerId, MageObjectReference toExclude) {
        if (toExclude == null) {
            return this.enteredThisTurn.getOrDefault(playerId, Collections.emptySet()).size();
        }
        return this.enteredThisTurn.getOrDefault(playerId, Collections.emptySet()).stream().filter(mor -> !toExclude.equals(mor)).mapToInt(x -> 1).sum();
    }
}

