/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.StitcherGeralfZombieToken;

class GeralfVisionaryStitcherEffect
extends OneShotEffect {
    GeralfVisionaryStitcherEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Create an X/X blue Zombie creature token, where X is the sacrificed creature's toughness";
    }

    private GeralfVisionaryStitcherEffect(GeralfVisionaryStitcherEffect effect) {
        super((OneShotEffect)effect);
    }

    public GeralfVisionaryStitcherEffect copy() {
        return new GeralfVisionaryStitcherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = 0;
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            for (Permanent permanent : ((SacrificeTargetCost)cost).getPermanents()) {
                xValue += permanent.getToughness().getValue();
            }
        }
        return new StitcherGeralfZombieToken(xValue).putOntoBattlefield(1, game, source, source.getControllerId());
    }
}

