/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class GetawayGlamerEffect
extends OneShotEffect {
    GetawayGlamerEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "Destroy target creature if no other creature has greater power";
    }

    private GetawayGlamerEffect(GetawayGlamerEffect effect) {
        super((OneShotEffect)effect);
    }

    public GetawayGlamerEffect copy() {
        return new GetawayGlamerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        if (targetCreature == null) {
            return false;
        }
        int powerOfTarget = targetCreature.getPower().getValue();
        List creatures = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game);
        for (Permanent creature : creatures) {
            if (creature.getPower().getValue() <= powerOfTarget) continue;
            return false;
        }
        targetCreature.destroy(source, game, false);
        return true;
    }
}

