/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.GainLifeEffect;
import mage.abilities.effects.common.LoseLifeOpponentsEffect;
import mage.abilities.effects.common.UntapTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.abilities.effects.common.continuous.GainControlTargetEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.ProtectionAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.SuperType;
import mage.counters.CounterType;
import mage.filter.Filter;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreatureOrPlaneswalkerPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.common.TargetCreatureOrPlaneswalker;

public final class GeyadroneDihada
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("permanents with corruption counters on them");
    private static final FilterPermanent filter2 = new FilterCreatureOrPlaneswalkerPermanent("other target creature or planeswalker");

    public GeyadroneDihada(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{1}{U}{B}{R}");
        this.supertype.add(SuperType.LEGENDARY);
        this.subtype.add((Object)SubType.DIHADA);
        this.setStartingLoyalty(4);
        this.addAbility((Ability)new ProtectionAbility((Filter)filter));
        LoyaltyAbility ability = new LoyaltyAbility((Effect)new LoseLifeOpponentsEffect(2), 1);
        ability.addEffect((Effect)new GainLifeEffect(2).concatBy("and"));
        ability.addEffect((Effect)new AddCountersTargetEffect(CounterType.CORRUPTION.createInstance(), Outcome.Detriment));
        ability.addTarget((Target)new TargetPermanent(0, 1, filter2));
        this.addAbility((Ability)ability);
        ability = new LoyaltyAbility((Effect)new GainControlTargetEffect(Duration.EndOfTurn), -3);
        ability.addEffect((Effect)new UntapTargetEffect().setText("Untap it"));
        ability.addEffect((Effect)new AddCountersTargetEffect(CounterType.CORRUPTION.createInstance(), Outcome.Detriment).setText("and put a corruption counter on it"));
        ability.addEffect((Effect)new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn).setText("It gains haste until end of turn"));
        ability.addTarget((Target)new TargetCreatureOrPlaneswalker());
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new LoyaltyAbility((Effect)new GainControlAllEffect(Duration.Custom, filter).setText("gain control of each permanent with a corruption counter on it"), -7));
    }

    private GeyadroneDihada(GeyadroneDihada card) {
        super((CardImpl)card);
    }

    public GeyadroneDihada copy() {
        return new GeyadroneDihada(this);
    }

    static {
        filter.add((Predicate)CounterType.CORRUPTION.getPredicate());
        filter2.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

