/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.g;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.keyword.ManifestEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;

class GhastlyConscriptionEffect
extends OneShotEffect {
    GhastlyConscriptionEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Exile all creature cards from target player's graveyard in a face-down pile, shuffle that pile, then manifest those cards. <i>(To manifest a card, put it onto the battlefield face down as a 2/2 creature. Turn it face up at any time for its mana cost if it's a creature card.)</i>";
    }

    private GhastlyConscriptionEffect(GhastlyConscriptionEffect effect) {
        super((OneShotEffect)effect);
    }

    public GhastlyConscriptionEffect copy() {
        return new GhastlyConscriptionEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || targetPlayer == null) {
            return false;
        }
        ArrayList<Card> cardsToManifest = new ArrayList<Card>();
        for (Card card : targetPlayer.getGraveyard().getCards((FilterCard)StaticFilters.FILTER_CARD_CREATURE, game)) {
            cardsToManifest.add(card);
            controller.moveCardToExileWithInfo(card, null, "", source, game, Zone.GRAVEYARD, true);
            card.setFaceDown(true, game);
        }
        if (cardsToManifest.isEmpty()) {
            return true;
        }
        Collections.shuffle(cardsToManifest);
        game.informPlayers(controller.getLogName() + " shuffles the face-down pile");
        game.processAction();
        ManifestEffect.doManifestCards((Game)game, (Ability)source, (Player)controller, new LinkedHashSet(cardsToManifest));
        return true;
    }
}

